<?php
/**
 * Mu Roulette
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="page-title"><span>'.lang('roulette_title_results').'</span></div>';

try {
	
	// check ticket id
	if(!check_value($_GET['ticket'])) throw new Exception(lang('roulette_error_19'));
	
	$MuRoulette = new \Plugin\MuRoulette\MuRoulette();
	$MuRoulette->setUsername($_SESSION['username']);
	$MuRoulette->setUserid($_SESSION['userid']);
	$MuRoulette->setTicketId($_GET['ticket']);
	$MuRoulette->redeemPrize();
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}